/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.rcp.IDEWorkbenchAdvisor;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.WorkbenchActionBuilder;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class IDEWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Point INITIAL_WINDOW_SIZE = new Point(1200, 940);
    private static final String SHOW_COOLBAR = "SHOW_COOLBAR";
    private static final String SHOW_PERSPECTIVEBAR = "SHOW_PERSPECTIVEBAR";
    private static final String TOOLBAR_MANUALLY_ADJUSTED = "TOOLBAR_MANUALLY_ADJUSTED";
    private static final String PERSPECTIVE_MANUALLY_ADJUSTED = "PERSPECTIVE_MANUALLY_ADJUSTED";
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private static final String WEB_PERSPECTIVE_ID = "com.aptana.ui.WebPerspective";
    private IDEWorkbenchAdvisor wbAdvisor;
    private boolean editorsAndIntrosOpened = false;
    private IEditorPart lastActiveEditor = null;
    private IPerspectiveDescriptor lastPerspective = null;
    private IWorkbenchPage lastActivePage;
    private String lastEditorTitle = "";
    private IPropertyListener editorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && IDEWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                String newTitle = IDEWorkbenchWindowAdvisor.getTitle(IDEWorkbenchWindowAdvisor.this.lastActiveEditor);
                if (!IDEWorkbenchWindowAdvisor.this.lastEditorTitle.equals(newTitle)) {
                    IDEWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }
        }
    };
    private IAdaptable lastInput;
    private ActionFactory.IWorkbenchAction openPerspectiveAction;
    private boolean isToolbarProgrammaticSet;

    public IDEWorkbenchWindowAdvisor(IDEWorkbenchAdvisor wbAdvisor, IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.wbAdvisor = wbAdvisor;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new WorkbenchActionBuilder(configurer);
    }

    private IWorkbench getWorkbench() {
        return this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
    }

    public boolean preWindowShellClose() {
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        return IDEWorkbenchWindowAdvisor.promptOnExit(this.getWindowConfigurer().getWindow().getShell());
    }

    static boolean promptOnExit(Shell parentShell) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            String message;
            MessageDialogWithToggle dlg;
            IWorkbenchWindow workbenchWindow;
            if (parentShell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                parentShell = workbenchWindow.getShell();
            }
            if (parentShell != null) {
                parentShell.setMinimized(false);
                parentShell.forceActive();
            }
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            if ((dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)parentShell, (String)IDEWorkbenchMessages.PromptOnExitDialog_shellTitle, (String)(message = productName == null ? IDEWorkbenchMessages.PromptOnExitDialog_message0 : NLS.bind((String)IDEWorkbenchMessages.PromptOnExitDialog_message1, (Object)productName)), (String)IDEWorkbenchMessages.PromptOnExitDialog_choice, (boolean)false, null, null)).getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
            }
        }
        return true;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.setShowPerspectiveBar(true);
        configurer.setShowFastViewBars(true);
        configurer.setShowProgressIndicator(true);
        configurer.setInitialSize(INITIAL_WINDOW_SIZE);
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter2(configurer.getWindow()));
        this.hookTitleUpdateListeners(configurer);
        final IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean showToolbar = store.getBoolean(SHOW_COOLBAR);
        boolean showPerspectiveBar = store.getBoolean(SHOW_PERSPECTIVEBAR);
        final WorkbenchWindow workbenchWindow = (WorkbenchWindow)configurer.getWindow();
        if (!showToolbar) {
            workbenchWindow.setCoolBarVisible(false);
        }
        if (!showPerspectiveBar) {
            workbenchWindow.setPerspectiveBarVisible(false);
        }
        workbenchWindow.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue = event.getNewValue();
                if (event.getProperty().equals("coolbarVisible") && newValue instanceof Boolean) {
                    store.setValue(IDEWorkbenchWindowAdvisor.SHOW_COOLBAR, ((Boolean)newValue).booleanValue());
                    if (!IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet) {
                        store.setValue(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED, true);
                    }
                }
                if (event.getProperty().equals("perspectiveBarVisible") && newValue instanceof Boolean) {
                    store.setValue(IDEWorkbenchWindowAdvisor.SHOW_PERSPECTIVEBAR, ((Boolean)newValue).booleanValue());
                    if (!IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet) {
                        store.setValue(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED, true);
                    }
                }
            }
        });
        workbenchWindow.addPerspectiveListener(new IPerspectiveListener(){
            private boolean resetting;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                String id;
                boolean isAptanaPerspective;
                if (!store.getBoolean(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED)) {
                    boolean showToolbar = true;
                    IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet = true;
                    workbenchWindow.setCoolBarVisible(showToolbar);
                    workbenchWindow.setPerspectiveBarVisible(showToolbar);
                    IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet = false;
                }
                if (isAptanaPerspective = (id = perspective.getId()).equals(IDEWorkbenchWindowAdvisor.WEB_PERSPECTIVE_ID)) {
                    if (this.resetting) {
                        store.setValue(MessageFormat.format("{0}:{1}", id, IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED), false);
                        IDEWorkbenchWindowAdvisor.this.customizePerspective(page);
                    } else if (!store.getBoolean(MessageFormat.format("{0}:{1}", id, IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED))) {
                        IDEWorkbenchWindowAdvisor.this.customizePerspective(page);
                    }
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                String id = perspective.getId();
                boolean isAptanaPerspective = id.equals(IDEWorkbenchWindowAdvisor.WEB_PERSPECTIVE_ID);
                if (isAptanaPerspective) {
                    if (changeId.equals("reset")) {
                        store.setValue(MessageFormat.format("{0}:{1}", perspective.getId(), IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED), true);
                        this.resetting = true;
                    } else if (changeId.equals("resetComplete")) {
                        this.resetting = false;
                    }
                }
            }
        });
    }

    private void customizePerspective(IWorkbenchPage page) {
        page.hideActionSet("org.eclipse.ui.edit.text.actionSet.annotationNavigation");
        page.hideActionSet("org.eclipse.ui.edit.text.actionSet.navigation");
        page.hideActionSet("org.eclipse.ui.externaltools.ExternalToolsSet");
    }

    public void postWindowOpen() {
        super.postWindowOpen();
    }

    public void openFile(File file, IWorkbenchWindow window) {
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)window.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageClosed(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle();
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partVisible(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    private String computeTitle() {
        String workspaceLocation;
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        IEditorPart activeEditor = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
        }
        String title = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
        }
        if (title == null) {
            title = "";
        }
        if (currentPage != null) {
            IAdaptable input;
            if (activeEditor != null) {
                this.lastEditorTitle = IDEWorkbenchWindowAdvisor.getTitle(activeEditor);
                title = String.valueOf(this.lastEditorTitle) + " - " + title;
            }
            IPerspectiveDescriptor persp = currentPage.getPerspective();
            String label = "";
            if (persp != null) {
                label = persp.getLabel();
            }
            if ((input = currentPage.getInput()) != null && !input.equals(this.wbAdvisor.getDefaultPageInput())) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = String.valueOf(label) + " - " + title;
            }
        }
        if ((workspaceLocation = this.wbAdvisor.getWorkspaceLocation()) != null) {
            title = String.valueOf(title) + " - " + workspaceLocation;
        }
        return title;
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    private void updateTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IEditorPart activeEditor = null;
        IWorkbenchPage currentPage = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        IAdaptable input = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
            persp = currentPage.getPerspective();
            input = currentPage.getInput();
        }
        if (activeEditor == this.lastActiveEditor && currentPage == this.lastActivePage && persp == this.lastPerspective && input == this.lastInput) {
            return;
        }
        if (this.lastActiveEditor != null) {
            this.lastActiveEditor.removePropertyListener(this.editorPropertyListener);
        }
        this.lastActiveEditor = activeEditor;
        this.lastActivePage = currentPage;
        this.lastPerspective = persp;
        this.lastInput = input;
        if (activeEditor != null) {
            activeEditor.addPropertyListener(this.editorPropertyListener);
        }
        this.recomputeTitle();
    }

    private static String getTitle(IEditorPart part) {
        String title = part.getTitleToolTip();
        return title.equals("") ? part.getTitle() : title;
    }

    public void postWindowRestore() throws WorkbenchException {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        int index = this.getWorkbench().getWorkbenchWindowCount() - 1;
        AboutInfo[] welcomePerspectiveInfos = this.wbAdvisor.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomePerspectiveInfos != null && index < welcomePerspectiveInfos.length) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = window.getActivePage();
            if (page == null && (pages = window.getPages()) != null && pages.length > 0) {
                page = pages[0];
            }
            String perspectiveId = welcomePerspectiveInfos[index].getWelcomePerspectiveId();
            if (page == null) {
                IAdaptable root = this.wbAdvisor.getDefaultPageInput();
                page = window.openPage(perspectiveId, root);
            } else {
                IPerspectiveRegistry reg = this.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspectiveId);
                if (desc != null) {
                    page.setPerspective(desc);
                }
            }
            window.setActivePage(page);
            page.openEditor((IEditorInput)new WelcomeEditorInput(welcomePerspectiveInfos[index]), WELCOME_EDITOR_ID, true);
        }
    }

    public void openIntro() {
        if (this.editorsAndIntrosOpened) {
            return;
        }
        this.editorsAndIntrosOpened = true;
        if (this.wbAdvisor.hasIntro()) {
            super.openIntro();
        } else {
            this.openWelcomeEditors(this.getWindowConfigurer().getWindow());
        }
    }

    private void openWelcomeEditors(IWorkbenchWindow window) {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return;
            }
            AboutInfo productInfo = new AboutInfo(product);
            URL url = productInfo.getWelcomePageURL();
            if (url == null) {
                return;
            }
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openWelcomeEditor(window, new WelcomeEditorInput(productInfo), null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            Map<String, AboutInfo> groups = this.wbAdvisor.getNewlyAddedBundleGroups();
            for (AboutInfo info : groups.values()) {
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
            }
            int wCount = this.getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.getWorkbench().openWorkbenchWindow(perspectiveId, this.wbAdvisor.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log((String)"Error opening window with welcome perspective.", (IStatus)e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.wbAdvisor.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
        }
    }

    public Control createEmptyWindowContents(Composite parent) {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Display display = composite.getDisplay();
        Color bgCol = display.getSystemColor(34);
        composite.setBackground(bgCol);
        Label label = new Label(composite, 64);
        label.setForeground(display.getSystemColor(33));
        label.setBackground(bgCol);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        String msg = IDEWorkbenchMessages.IDEWorkbenchAdvisor_noPerspective;
        label.setText(msg);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.openPerspectiveAction = ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window);
        toolBarManager.add((IAction)this.openPerspectiveAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        toolBar.setBackground(bgCol);
        return composite;
    }

    public void dispose() {
        if (this.openPerspectiveAction != null) {
            this.openPerspectiveAction.dispose();
            this.openPerspectiveAction = null;
        }
        super.dispose();
    }

    class EditorAreaDropAdapter2
    extends EditorAreaDropAdapter {
        IWorkbenchWindow window;

        public EditorAreaDropAdapter2(IWorkbenchWindow window) {
            super(window);
            this.window = window;
        }

        public void drop(DropTargetEvent event) {
            TransferData currentTransfer = event.currentDataType;
            if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
                String[] names = (String[])event.data;
                File[] files = new File[names.length];
                int i = 0;
                while (i < files.length) {
                    IDEWorkbenchWindowAdvisor.this.openFile(new File(names[i]), this.window);
                    ++i;
                }
            } else {
                super.drop(event);
            }
        }
    }
}

